<?php

namespace Hilco\Models;

/**
 * Class PromotionBillingTrigger
 * @package Hilco\Models
 * @property boolean $only_direct_billing
 */
class PromotionBillingTypeTrigger extends PromotionTriggerDetails {
    protected $table = "PromotionBillingTypeTriggers";
    protected $fillable = ['only_direct_billing'];

    public function isTriggered(Customer $soldToCustomer, $webCartItems, $distinctPartInfo = []) {
        $customerSegment = $soldToCustomer->customerSegment;
        return isset($customerSegment) && $customerSegment->getCustNo() == $customerSegment->getBillCustNo();
    }

    public function postTriggerOperation($soldToCustomer){}
}