<?php

namespace Hilco\Models;

use DB;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

/**
 * M3 price lists table (base price)
 * @property-read string $PRRF
 */
class OPRBAS extends Model {
    protected $table = "OPRBAS";

    /**
     * @return string
     */
    public function getPriceList() {
        return $this->PRRF;
    }

    /**
     * @param $pricelistConnection , "hilco-pricelist-a" or "hilco-pricelist-b" (fetch from PriceListSchemas table)
     * @param $priceListDesc , e.g. "US_CATALOG" (CustomerSegments.def_pricelist_desc)
     * @param $custNo, e.g., "70727975" (Customers.cust_no) OR ""
     * @param $currency , e.g., "USD" (Customers.currency)
     * @param $itemNo , e.g. "1097264" (Parts.part_no, WebParts.part_number, etc)
     * @return OPRBAS|Builder|Model|object|null
     */
    public static function findPriceRecordForItem ($pricelistConnection, $priceListDesc, $custNo, $currency, $itemNo) {
        return
            OPRBAS::on($pricelistConnection)
                ->where('PRRF', $priceListDesc)
                ->where('CUNO', $custNo)
                ->where('CUCD', $currency)
                ->where('ITNO', $itemNo)
                ->where('FVDT', '<=', DB::raw("DATE_FORMAT(CURDATE(), '%Y%m%d')"))
                ->where('VFDT', '<=', DB::raw("DATE_FORMAT(CURDATE(), '%Y%m%d')"))
                ->where("LVDT", ">=", DB::raw("DATE_FORMAT(CURDATE(), '%Y%m%d')"))
                ->where("deleted", "=", 0)
                ->first();
    }
}