<?php

namespace Hilco\Models;

/**
 * Hilco\Models\CarrierTrackingUrl
 * @property-read string $carrier
 * @property-read string $url
 */
class CarrierTrackingUrl extends WebModel {
    protected $table = "CarrierTrackingUrls";

    public function getUrl(): string {
        return $this->url;
    }

    public static function getUrlByCarrier (string $carrier): ?string {
        $matchedCarrier = CarrierTrackingUrl::where('carrier', $carrier)->first();
        return isset($matchedCarrier) ? $matchedCarrier->getUrl() : null;
    }
}