<?php

namespace Hilco\Models;
use DB;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;


/**
 * Hilco\Models\Carrier
 *
 * @property integer $id
 * @property string $carrier_code
 * @property string $carrier_desc
 * @property string $bill
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Carrier whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Carrier whereCarrierCode($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Carrier whereCarrierDesc($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Carrier whereBill($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Carrier whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Carrier whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Carrier whereDateUploaded($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Carrier whereDeletedAt($value)
 * @mixin \Eloquent
 */
class Carrier extends Model {
	protected $table = "Carriers";

	public function rateShopGroups() {
	    return $this->hasMany(RateShopGroup::class, 'hilco_carrier_code', 'carrier_code');
    }

    public function scopeInRateShopGroup($query, $groupCode) {
	    return $query->whereHas('rateShopGroups', function ($query) use ($groupCode) {
	        return $query->groupCode($groupCode);
        });
    }

    public function rateShopAPIDetails() {
	    return $this->hasOne(RateShopAPIDetails::class, 'hilco_carrier_code', 'carrier_code');
    }

    public function scopeNoAirServices($query) {
	    return $query->whereHas('rateShopAPIDetails', function ($query) {
	        $query->where('is_air', 0);
        });
    }

    public function getBillsHilcoAttribute($value) {
	    return $this->bill == 'Hico' || $this->bill == 'Hilco';
    }
}
