<?php
/**
 * Created by PhpStorm.
 * User: brian
 * Date: 4/1/19
 * Time: 4:11 PM
 */

namespace Hilco\Models;

use DB;
use Illuminate\Database\Query\JoinClause;

/**
 * Hilco\Models\ApplicationTranslation
 *
 * @property integer $id
 * @property string $application
 * @property string $translationkey_id
 * @property string $language
 * @property string $translation
 * @property string $deleted_at
 * @property integer $commit_sequence
 */
class ApplicationTranslation extends WebModel {

    protected $table = "ApplicationTranslations";
    protected $fillable = [
        'application', 'translationkey_id', 'language', 'translation'
    ];

    // Scopes
    public function scopeByTranslationKeyLanguage ($query, $translationKeyId, $language) {
        return $query->where('translationkey_id', $translationKeyId)->where('language', $language);
    }

    public function scopeExportQuery($query){
        return $query
            ->select([
                'ApplicationTranslations.id',
                'atk.id as translationkey_id',
                'atk.application',
                'atk.description as description',
                'ApplicationTranslations.translation as english_source',
                'AvailableLanguages.language_code',
                'atInner.translation as translation'
            ])
            ->join('AvailableLanguages', DB::raw('1'), '=', DB::raw('1'))
            ->join('ApplicationTranslationKeys as atk', 'translationkey_id', '=', 'atk.id')
            ->leftJoin('ApplicationTranslations as atInner', function(JoinClause $join){
                $join
                    ->on('ApplicationTranslations.translationkey_id', '=', 'atInner.translationkey_id')
                    ->on('atInner.language', '=', 'AvailableLanguages.language_code')
                    ->where('atInner.deleted_at', '=', '0000-00-00 00:00:00');
            })
            ->where('ApplicationTranslations.deleted_at', '=', '0000-00-00 00:00:00')
            ->where('ApplicationTranslations.language', '=', 'en');
    }

    use HasCommitSequence;
}