<?php

namespace Hilco\Models;

use Illuminate\Support\Collection;

class PriceListCampaign extends WebModel
{
    protected $table = 'CampaignPriceLists';

    public function scopePriceGroup($query, $group) {
        return $query->where('sales_code', '=', $group)->where('sales_type', '=', 'Customer Price List Group');
    }

    public function scopeCustomer($query, $customer) {
        return $query->where('sales_code', '=', $customer)->where('sales_type', '=', 'Customer');
    }

    public function scopeCustomerType($query) {
        return $query->where('sales_type', '=', 'Customer');
    }

    public function scopeCustomerGroupType($query) {
        return $query->where('sales_type', '=', 'Customer Price List Group');
    }

    public function scopeActive($query) {
        return $query
            ->whereRaw('start_date <= DATE(NOW())')
            ->where(function ($wheres) {
                return $wheres
                    ->whereRaw('end_date >= DATE(NOW())')
                    ->orWhere('end_date', '=', '1753-01-01')
                ;
            })
        ;
    }
}
