<?php

namespace Marcolin\Models;

class PromotionCustomerTrigger extends PromotionTriggerDetails
{
    protected $table = 'PromotionCustomerTriggers';
    protected $fillable = ['target_all_customers', 'one_time_use'];

    public function customers()
    {
        return $this->belongsToMany(Customer::class, 'PromotionCustomerTrigger_Customer', 'promotioncustomertrigger_id', 'customer_id')
            ->withPivot(['excluded', 'redeemed']);
    }

    public function isTriggered(Customer $soldToCustomer, $webCartItems)
    {
        if($this->one_time_use) {
            $customer = $this->customers()->wherePivot('customer_id', '=', $soldToCustomer->id)->where('redeemed', 0)->first();
            if (is_null($customer) && $this->target_all_customers) {
                return true;
            }
        } else {
            if ($this->target_all_customers) {
                return true;
            } else {
                $customer = $this->customers()->wherePivot('customer_id', '=', $soldToCustomer->id)->first();
            }
        }
        return !is_null($customer);
    }
}
