<?php

namespace Marcolin\Models;

use DB;

class UACReportModuleInstanceAlert extends WebModel
{
    protected $table = "UACReportModuleInstanceAlerts";

    protected $fillable = ['uacreportmoduleinstance_id', 'name', 'description', 'enabled', 'email_on_trigger'];

    public function uacReportModuleInstance() {
        return $this->belongsTo(UACReportModuleInstance::class, 'uacreportmoduleinstance_id', 'id');
    }

    public function triggers() {
        return $this->hasMany(UACReportModuleInstanceAlertTrigger::class, 'uacreportmoduleinstancealert_id', 'id');
    }

    public function getIsTriggeredAttribute() {
        foreach ($this->triggers as $trigger) {
            if ($trigger->is_triggered) {
                return true;
            }
        }
        return false;
    }

    public function getReadableDescriptionAttribute() {
        foreach ($this->triggers as $trigger) {
            if ($trigger->is_triggered) {
                return $trigger->readable_description;
            }
        }
        return null;
    }
}
