<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 11/3/17
 * Time: 12:59 PM
 */

namespace Marcolin\Models;
use DB;

trait HasCommitSequence {
    public function save(array $options = []) {
        if ($options && $options['ignoreCommitSequence']) {
            unset($options['ignoreCommitSequence']);
            return parent::save($options);
        } else {
            DB::transaction(function () use ($options) {
                $commitSequence = DB::table($this->getTable())->lockForUpdate()->max('commit_sequence') + 1;
                $this->commit_sequence = $commitSequence;
                return parent::save($options);
            });
        }
    }

    public function delete() {
        DB::transaction(function() {
            $commitSequence = DB::table($this->getTable())->lockForUpdate()->max('commit_sequence') + 1;
            $this->commit_sequence = $commitSequence;
            parent::save();
            parent::delete();
        });
    }
}