<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 7/8/16
 * Time: 3:01 PM
 */

namespace Marcolin\Controllers;

use Illuminate\Http\Request;
use Response;

trait HasSelect2Search
{

    /**
     * Default method, override this for it to work.
     */
    public function getS2SearchModel()
    {
        return false;
    }

    public function s2search(Request $request)
    {
        $page       = $request->get('page', 0);
        $filters    = $request->get('filters', []);
        $condition  = $request->get('condition', 'and');
        $orderBy    = $request->get('orderBy', false);
        
        $queryModel = $this->getS2SearchModel();
        
        if (!$queryModel) return Response::json([]);

        $firstFilter = true;
        foreach ($filters as $filter) {
            if (!$firstFilter && $condition == 'or') {
                $whereMethod = 'orWhere';
            } else {
                $whereMethod = 'where';
                $firstFilter = false;
            }

            $column = array_get($filter, 'column');
            $operator = array_get($filter, 'operator', '=');
            $value = array_get($filter, 'value');
            if (strtolower($operator) == 'like') $value = "%$value%";

            $queryModel->$whereMethod($column, $operator, $value);
        }

        $totalCount = $queryModel->count();
        if ($orderBy !== false) {
            $queryModel = $queryModel->orderBy($orderBy, 'asc');
        }

        $totalCount = $queryModel->count();
        $results = $queryModel->offset($page * 30)->take(30)->get();

        return Response::json(['items' => $results, 'total_count' => $totalCount, 'page' => $page]);
    }
}