<?php

namespace Marcolin\Models;
use DB;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;


class SalesRep extends WebModel
{
	protected $table = "SalesReps";

	public function brands() {
        return $this->belongsToMany(Brand::class, 'SalesRep_Customer_Brand', 'salesrep_id', 'brand_id')->distinct();
    }

    public function salesDistrict() {
        return $this->belongsToMany(SalesDistrict::class, 'SalesRep_Customer_Brand', 'salesrep_id', 'salesDistrict_id')->withPivot('brand_id');
    }
}
