<?php

namespace Marcolin\Models;

class PromotionItemDiscountAction extends PromotionActionDetails {
    protected $table = 'PromotionItemDiscountActions';
    protected $fillable = ['discount_percent', 'discount_entire_order', 'commit_sequence'];

    // Overrides Model::boot(), used to define a specific 'deleted' state
    public static function boot() {
        parent::boot();
        // make sure all related rows in PromotionItemDiscountAction_Product are also deleted
        static::deleted(function (PromotionItemDiscountAction $promotionItemDiscountAction) {
            $promotionItemDiscountActionProducts =
                PromotionItemDiscountAction_Product::where('promotionitemdiscountaction_id', '=', $promotionItemDiscountAction->id);
            foreach ($promotionItemDiscountActionProducts as $promotionItemDiscountActionProduct) {
                $promotionItemDiscountActionProduct->delete();
            }
        });
    }

    /**
     * @param Customer $soldToCustomer
     * @param $webCartItems
     * @param $status
     * @return mixed|void
     */
    public function takeAction(Customer $soldToCustomer, $webCartItems, &$status) {}

    /**
     * Get all WebBrands specifically targeted by this action
     * @return mixed
     */
    public function webBrands() {
        return $this
            ->morphedByMany(WebBrand::class, 'product',
                'PromotionItemDiscountAction_Product', 'promotionitemdiscountaction_id')
            ->withPivot(['excluded'])
            ->where('PromotionItemDiscountAction_Product.deleted_at', '=', '0000-00-00 00:00:00')
            ;
    }

    /**
     * Get all WebStyles specifically targeted by this action
     * @return mixed
     */
    public function webStyles() {
        return $this
            ->morphedByMany(WebStyle::class, 'product',
                'PromotionItemDiscountAction_Product', 'promotionitemdiscountaction_id')
            ->withPivot(['excluded'])
            ->where('PromotionItemDiscountAction_Product.deleted_at', '=', '0000-00-00 00:00:00')
            ;
    }

    /**
     * Get all WebUnits specifically targeted by this action
     * @return mixed
     */
    public function webUnits() {
        return $this
            ->morphedByMany(WebUnit::class, 'product',
                'PromotionItemDiscountAction_Product', 'promotionitemdiscountaction_id')
            ->withPivot(['excluded'])
            ->where('PromotionItemDiscountAction_Product.deleted_at', '=', '0000-00-00 00:00:00')
            ;
    }
}
