<?php

namespace Marcolin;

use Illuminate\Support\Facades\App;
use Marcolin\Models\Customer;
use Marcolin\Models\Promotion;
use Marcolin\Models\PromotionCodeTrigger;
use Marcolin\Models\PromotionCodeTrigger_Code;
use Marcolin\Models\WebSilo;
use Marcolin\Models\WebUnit;

/**
 * Class B2BHelper
 * @package Marcolin
 */
class B2BHelper {
    protected $activeCustomer;
    protected $activeLanguage;
    protected $activePromotion;
    protected $activePromoCode;
    protected $activeShippingAddress;
    protected $activeWebSilo;
    protected $activeCouponCode;

    public function __construct() {
        $activeShippingAddress = null;
//        $this->loadActiveLanguage();
        $this->loadActiveCustomer();
    }

//  ******************************** LOAD ********************************

    protected function loadActiveCustomer() {
        $this->activeCustomer = false;

        $aliasedCustomerId = session()->get('aliasedCustomerId', false);

        if ($aliasedCustomerId) {
            $this->activeCustomer = Customer::where('Customers.id', '=', $aliasedCustomerId)
                ->with('brands')
//                ->with('shippingAddresses.dropshipOriginCustomer')
//                ->with('shippingAddresses.dropshipDestinationCustomer')
//                ->with('rebateDashboardAccountTotal.rebateDashboardAssociation.rebateDashboardAssociationRule')
//                ->with('rewardDashboardAccountTotal.rewardDashboardGroup.rewardDashboardGroupRule')
                ->first();
        } else {
            $user = auth()->user();
            if ($user) {
                $this->activeCustomer =
                    $user
                        ->customer()
                        ->with('brands')
//                        ->with('shippingAddresses.dropshipOriginCustomer')
//                        ->with('shippingAddresses.dropshipDestinationCustomer')
//                        ->with('rebateDashboardAccountTotal.rebateDashboardAssociation.rebateDashboardAssociationRule')
//                        ->with('rewardDashboardAccountTotal.rewardDashboardGroup.rewardDashboardGroupRule')
                        ->first();
            }
        }

        $this->setActiveShippingAddress();

        $this->loadActiveWebSilo();

        $this->loadActivePromotion();

    }

//    protected function loadActiveLanguage() {
//        $this->activeLanguage = false;
//
//        $activeLanguage = session()->get('activeLanguage', false);
//        if ($activeLanguage && $activeLanguage != App::getLocale()) {
//            $this->activeLanguage = $activeLanguage;
//        } else {
//            $this->activeLanguage = App::getLocale();
//            session()->put('activeLanguage', $this->activeLanguage);
//        }
//    }

    protected function loadActiveWebSilo() {
        $this->activeWebSilo = false;

        $activeWebSiloId = session()->get('activeWebSiloId', false);

        if (!$activeWebSiloId) {
            if (auth()->user()) {
                $defaultWebSilo = auth()->user()->defaultWebSilo;
                if ($defaultWebSilo) {
                    $activeWebSiloId = $defaultWebSilo->id;
                }
            }

            if (!$activeWebSiloId) $activeWebSiloId = WebSilo::first()->id;
        }
        $this->activeWebSilo = WebSilo::with('webLandingPage')->find($activeWebSiloId);
        session()->put('activeWebSiloId', $activeWebSiloId);

        return $this->activeWebSilo;
    }

    protected function loadActivePromotion() {
        $this->activePromotion = false;

        $activePromotionId = session()->get('activePromotionId', false);

        if ($activePromotionId) {
            $this->activePromotion = Promotion::find($activePromotionId);
        }

        $this->loadActivePromoCode();
    }

    protected function loadActivePromoCode() {
        $this->activePromoCode = false;

        $currentPromoCode = session()->get('promoCode', false);

        if ($this->activePromotion) {
            $codeTrigger = $this->activePromotion->codeTriggers->get(0);
            if ($currentPromoCode && $currentPromoCode === $codeTrigger->code) {
                $this->activePromoCode = $currentPromoCode;
            } else {
                $this->activePromoCode = $codeTrigger->code;
                session()->put('promoCode', $this->activePromoCode);
            }
        } else {
            session()->put('promoCode', false);
        }

        $this->loadActiveCouponCode();
    }

    protected function loadActiveCouponCode() {
        $this->activeCouponCode = false;

        $currentActiveCouponCode = session()->get('couponCode', false);

        if ($currentActiveCouponCode && $this->activePromotion && $this->activePromoCode) {
            $codeTrigger = $this->activePromotion->codeTriggers->get(0);
            if ($codeTrigger->is_list && null !== $codeTrigger->byCouponCode($currentActiveCouponCode)->first()) {
                $this->activeCouponCode = $currentActiveCouponCode;
            }
        } else {
            session()->put('couponCode', false);
        }
    }
//  **********************************************************************

//  ******************************** ALIASING ****************************
    public function aliasAs($customerId = false) {
        if ($customerId) {
            session()->put('aliasedCustomerId', $customerId);
        } else {
            session()->forget('aliasedCustomerId');
            session()->forget('activeWebSiloId');
            $this->loadActiveWebSilo();
        }
        $this->loadActiveCustomer();
    }

    public function isAliased() {
        return (session()->get('aliasedCustomerId', false));
    }

    public function stopAliasing() {
        $this->aliasAs(false);
    }
//  **********************************************************************

//  ******************************** SETTERS *****************************
    public function setActiveShippingAddress($customerShippingAddress = false) {
        if ($customerShippingAddress === false) {
            if ($this->activeCustomer) {
                $customerShippingAddress = $this->activeCustomer->default_shipping_address;
            }
        }
        $this->activeShippingAddress = $customerShippingAddress;
        return $this->activeShippingAddress;
    }

//    public function setActiveLanguage($language) {
//        session()->put('activeLanguage', $language);
//        $this->loadActiveLanguage();
//    }

    public function setActivePromotion($promotion, $couponCode = null) {
        if (is_null($promotion)) {
            session()->forget('activePromotionId');
            $this->activePromotion = false;
            session()->forget('promoCode');
            $this->activePromoCode = false;
            session()->forget('couponCode');
            $this->activeCouponCode = false;
        } else {
            $currentActivePromotionId = session()->get('activePromotionId', false);
            if (!$currentActivePromotionId || $currentActivePromotionId !== $promotion->id) {
                $this->activePromotion = $promotion;
                session()->put('activePromotionId', $promotion->id);

                $codeTrigger = $this->activePromotion->codeTriggers->get(0);

                if ($couponCode !== null &&
                    $codeTrigger->is_list &&
                    null !== $codeTrigger->byCouponCode($couponCode)->first()) {

                    $this->activeCouponCode = $couponCode;
                    session()->put('couponCode', $this->activeCouponCode);

                }

                $this->activePromoCode = $codeTrigger->code;
                session()->put('promoCode', $this->activePromoCode);
            }
        }
    }
//  **********************************************************************

//  ******************************** GETTERS *****************************
    public function activeCustomer() {
        return $this->activeCustomer;
    }

    public function activeShippingAddress()
    {
        return $this->activeShippingAddress;
    }

    public function activeCountry()
    {
        if ($this->activeShippingAddress) return $this->activeShippingAddress()->country;

        return null;
    }

    public function activeCurrency()
    {
        $activeCurrency = 'USD';

        if ($this->activeCustomer) {
            $activeCurrency = $this->activeCustomer->currency;
        }

        return $activeCurrency;
    }

    public function activeWebSilo()
    {
        return $this->activeWebSilo;
    }

//    public function activeLanguage() {
//        return $this->activeLanguage;
//    }

    public function activePromotion() {
        return $this->activePromotion;
    }

    public function activePromoCode() {
        return $this->activePromoCode;
    }

    public function activeCouponCode() {
        return $this->activeCouponCode;
    }
//  **********************************************************************

//  ******************************** PROMOS ******************************
    public function eligiblePromotions() {
        return ($this->activeCustomer ? Promotion::getEligiblePromotions() : []);
    }

    public function unQualifiedPromotions() {
        return ($this->activeCustomer ? Promotion::getUnQualifiedPromotions() : []);
    }

    public function isValidPromoCode($code) {
        $codeTrigger = PromotionCodeTrigger::byCode($code)->first();

        if ($codeTrigger == null) {
            $codeTriggerCode = PromotionCodeTrigger_Code::byCode($code)->first();
            if ($codeTriggerCode !== null && $codeTriggerCode->is_redeemed == 0) {
                $codeTrigger = $codeTriggerCode->promotionCodeTrigger;
                if ($codeTrigger->is_list == 0) {
                    // even through the coupon code is technically valid,
                    // if the code trigger on the promo isn't configured
                    // for a coupon list then it shouldn't be redeemable
                    $codeTrigger = null;
                }
            }
        } else if ($codeTrigger->is_list == 1) {
            // conversely, if someone somehow knew the backend promo code
            // for a promo that is supposed to have a coupon code list,
            // still return false because they shouldn't be allowed to redeem
            $codeTrigger = null;
        }

        if (isset($codeTrigger)) {
            // finally, verify that the promotion that this code matches to
            // actually is an eligible promotion to begin with
            $promotion = $codeTrigger->promotion()->first();
            if (isset($promotion)) {
                foreach ($this->eligiblePromotions() as $eligiblePromotion) {
                    if ($promotion->id === $eligiblePromotion->id) {
                        return $promotion;
                    }
                }
            }
        }

        return false;
    }
//  **********************************************************************

//  ***************************** TRANSLATIONS ***************************
//    public function availableLanguages() {
//        if (config('app.env') !== 'production') {
//            return ['en', 'fr', 'foo'];
//        } else {
//            return ['en', 'fr'];
//        }
//    }
//
//    public function getB2BTranslation($bladePath, $translationKey, $placeHolder) {
//        // FOO Test Handler
//        if (b2b()->activeLanguage() == 'foo') {
//            return 'FOO';
//        }
//        // FOO Test Handler
//
//        return $this->getApplicationTranslation('b2b', $bladePath, $translationKey, $placeHolder);
//    }
//
//    /**
//     * Gets the ApplicationTranslation record identified by the
//     * $application, $bladePage, $translationKey, and current $activeLanguage
//     * If a record isn't found for the current $activeLanguage, return the
//     * translation text record for English (en)
//     * If somehow there isn't an English translation for the intended text,
//     * return the value in $placeHolder.
//     * @param $application
//     * @param $component
//     * @param $translationKey
//     * @param $placeHolder
//     * @return mixed
//     */
//    public function getApplicationTranslation($application, $component, $translationKey, $placeHolder) {
//        $translation = $placeHolder;
//
//        $applicationTranslationKey =
//            ApplicationTranslationKey::byApplicationComponentKey($application, $component, $translationKey)->first();
//
//        if ($applicationTranslationKey) {
//            $applicationTranslation =
//                ApplicationTranslation
//                    ::byTranslationKeyLanguage($applicationTranslationKey->id, b2b()->activeLanguage())->first();
//            if ($applicationTranslation) {
//                $translation = $applicationTranslation->translation;
//            } else {
//                $defaultTranslation =
//                    ApplicationTranslation
//                        ::byTranslationKeyLanguage($applicationTranslationKey->id, 'en')->first();
//                if ($defaultTranslation) {
//                    $translation = $defaultTranslation->translation;
//                }
//            }
//        }
//
//        return $translation;
//    }
//
//    public function getB2BDataTablesTranslationParameters($bladePath) {
//        return $this->getDataTablesTranslationParameters('b2b', $bladePath);
//    }
//
//    public function getDataTablesTranslationParameters($application, $component) {
//        // FOO Test Handler
//        if (b2b()->activeLanguage() == 'foo') {
//            return config('datatables.language_foo');
//        }
//        // FOO Test Handler
//
//        if (!ApplicationTranslationKey::byApplicationComponent($application, $component)->get()->count()) {
//            $component = 'datatables.default';
//        }
//
//        $translationsArray = config('datatables.language_placeholders');
//        foreach ($translationsArray as $languageKey => $languageValue) {
//            if (is_array($languageValue)) {
//                foreach($languageValue as $subKey => $subValue) {
//                    $translationsArray[$languageKey][$subKey] =
//                        $this->getApplicationTranslation($application, $component,
//                            $languageKey.'.'.$subKey, $translationsArray[$languageKey][$subKey]);
//                }
//            } else {
//                $translationsArray[$languageKey] =
//                    $this->getApplicationTranslation($application, $component,
//                        $languageKey, $translationsArray[$languageKey]);
//            }
//        }
//
//        return $translationsArray;
//    }
//  **********************************************************************

    public function currencySymbol($getHTMLEntity = true) {
        return $getHTMLEntity ? '&dollar;' : '$';
    }

    public function formatPrice($price, $decimals = -1, $symbol = '$')
    {
        if ($decimals = -1) {
            if ($price == round($price)) $decimals = 0;
            else $decimals = 2;
        }
        return $symbol . number_format($price, $decimals);
    }

    public function getWebUnitById($webUnitId) {
        return WebUnit::where('id', $webUnitId)->first();
    }

    public function activeSalesOrg() //TODO delete this
    {
        return array_get($this->activeCustomer, 'salesOrg', 'UN01');
    }

    public function completeAlmostheader($almostQualifiedPromoInfo) { //TODO delete this
        $almostHeader = $almostQualifiedPromoInfo['promotion']->almost_header;

        foreach($almostQualifiedPromoInfo['triggers'] as $trigger) {
            if(strcasecmp($trigger['type'], "minimum_quantity") == 0){
                $almostHeader = preg_replace(
                    '/QTY_LEFT/',
                    $trigger['amountLeft'],
                    $almostHeader);
            }
            if(strcasecmp($trigger['type'], "minimum_dollar") == 0){
                $almostHeader = preg_replace(
                    '/SPENDING_LEFT/',
                    $trigger['amountLeft'],
                    $almostHeader);
            }
        }

        return $almostHeader;
    }
}