<?php

namespace Hilco\Models;
use AlgoliaSearch\Laravel\AlgoliaEloquentTrait;
use DB;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\App;
use Venturecraft\Revisionable\RevisionableTrait;
use Illuminate\Support\Facades\Input;

class WebBrand extends WebModel implements HasLandingPageInterface {
    protected $table = "WebBrands";
    protected $fillable = ['name', 'slug', 'brand_id', 'is_visible', 'detail', 'sort_priority'];
    protected $casts = [
        ['is_visible' => 'boolean']
    ];
    protected $perPage = 24;

    public function getPerPage()
    {
        $tmpPerPage =Input::get('perPage');
        return (isset($tmpPerPage) && $tmpPerPage > 0)?$tmpPerPage:$this->perPage;
    }

    public function webSilos() {
        return $this->belongsToMany(WebSilo::class, 'WebBrand_WebSilo', 'webbrand_id', 'websilo_id')->withPivot('display_order');
    }

    public function brand() {
        return $this->belongsTo(Brand::class);
    }

    public function webStyles() {
        return $this->belongsToMany(WebStyle::class, 'WebStyle_WebBrand', 'webcollection_id', 'webfamily_id')->withPivot(['is_featured', 'display_order']);
    }

    public function visibleWebStyles() {
        return $this->belongsToMany(WebStyle::class, 'WebStyle_WebBrand', 'webcollection_id', 'webfamily_id')
            ->withPivot(['is_featured', 'display_order'])
            ->visible()
            ->displayOrder()
        ;
    }

    public function scopeDisplayOrder(Builder $query) {
        return $query->orderBy('pivot_display_order', 'asc')->orderBy('name', 'asc');
    }

    public function scopeAlphabetical(Builder $query) {
        return $query->orderBy('name', 'asc');
    }

    public function getFeaturedChildrenAttribute() {
        return $this->visibleWebStyles()->wherePivot('is_featured', 1)->get();
    }

    public function getChildrenAttribute() {
        return $this->visibleWebStyles()->get();
    }

    public function scopeInCategory($query, $webCategoryId) {
        return $query->whereHas('webCategories', function ($query) use ($webCategoryId) {
            $query->where('webcategory_id', $webCategoryId);
        });
    }

    public function scopeHavingFamily($query, $webStyleId) {
        return $query->whereHas('webStyles', function ($query) use ($webStyleId) {
            $query->where('webfamily_id', $webStyleId);
        });
    }

    public function setWebCategoryIdsAttribute($ids) {
        $this->save();
        $this->createRevisionRecord('webCategoryIds', $this->webCategories->pluck('id')->toJson(), json_encode($ids));
        $this->webCategories()->sync($ids);
    }

    public function getHierarchyPathsAttribute() {
        $paths = [];
        foreach ($this->webCategories as $webCategory) {
            foreach ($webCategory->webBrands as $webBrand) {
                foreach ($webBrand->webSilos as $webSilo) {
                    $paths[] = [
                        'webSilo' => $webSilo,
                        'webBrand' => $webBrand,
                        'webCategory' => $webCategory,
                    ];
                }
            }
        }
        return $paths;
    }

    public function scopeInCollection($query, $webCollection) {
        return $query->whereHas('webCollections', function ($query) use ($webCollection) {
            $query->where('webcollection_id', $webCollection->id);
        });
    }

    public function scopeInSilo($query, $webSiloId) {
        return $query->whereHas('webCategories', function ($query) use ($webSiloId) {
            return $query->inSilo($webSiloId);
        });
    }    

    public function getAssetPrefix() {
        return "webCollections/{$this->id}";
    }

    public function scopeVisible(Builder $query) {
        $query
            ->where('WebBrands.is_visible', '1')
//            ->whereHas('webStyles', function ($query) {
//                return $query->visible();
//            })
        ;

        return $query;
    }

    public function slugUrl() {
        return route('collection.slug', [$this->slug]);
    }

    public function getParentRelationName() {
        return 'webCategories';
    }

    public function getPrimaryImage() {
        $asset = $this->assetsByType('primary')->first();
        if (!is_null($asset)) return $asset;

        $webStyle = $this->visibleWebStyles->first();
        if ($webStyle) return $webStyle->getPrimaryImage();
    }

    public function getNameAttribute($name) {
        if (isset($name) && strlen($name) > 0) {
            return $name;
        }

        $name = $this->brand->name;
        if (isset($name) && strlen($name) > 0) {
            return $name;
        }

        return $this->slug;
    }


    use HasAssets, HasSlug, HasLandingPage, RevisionableTrait, ManyToManyRevisionableTrait;
}
