<?php

namespace Hilco\Models;
use DB;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;


/**
 * Hilco\Models\FOB
 *
 * @property integer $id
 * @property string $fob_code
 * @property string $fob_desc
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\FOB whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\FOB whereFobCode($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\FOB whereFobDesc($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\FOB whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\FOB whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\FOB whereDateUploaded($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\FOB whereDeletedAt($value)
 * @mixin \Eloquent
 */
class Style extends Model
{
	protected $table = "Styles";

    function brand() {
        return $this->belongsTo(Brand::class);
    }

    function productDescription() {
        return $this->hasMany(ProductDescription::class, "style", "style");
    }

    function units() {
        return $this->hasMany(Unit::class);
    }

    public function webStyle() {
        return $this->hasOne(WebStyle::class);
    }

    public function getNameAttribute() {
        $productDescription = $this->productDescription;
        if (isset($productDescription) && count($productDescription) > 0) {
            $styleName = $productDescription->first()->styleName;
            if (strlen($styleName) > 0) {
                return title_case($productDescription->first()->styleName);
            }
        }
        return $this->style;
    }

    public function getCustomerPrice($customer) {
        $unit = $this->units()->first();
        if (isset($unit)) {
            return $unit->getCustomerPrice($customer);
        } else {
            return null;
        }
    }
}
