<?php

namespace Hilco\Models;
use DB;
use Hilco\SoftDeletes;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;


/**
 * Hilco\Models\FOB
 *
 * @property integer $id
 * @property string $fob_code
 * @property string $fob_desc
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @mixin \Eloquent
 */
class SalesOrderNote extends UuidModel
{
	protected $table = "SalesOrderNotes";

    use SoftDeletes;

    public function salesOrder() {
        return $this->belongsTo(SalesOrder::class, 'salesOrder_id', 'id');
    }
}
