<?php

namespace Marcolin\Models;

class WebRole extends WebModel
{

    protected $table = 'WebRoles';
    protected $fillable = ['name', 'slug', 'description', 'is_enabled'];
    protected $with = ['webPermissions'];

    public function webUsers()
    {
        return $this->belongsToMany(WebUser::class, 'WebRole_WebUser');
    }

    public function webPermissions()
    {
        return $this->belongsToMany(WebPermission::class, 'WebPermission_WebRole', 'webrole_id', 'webpermission_id');
    }

    public static function getDefault()
    {
        return WebRole::where('slug', config('marcolin.defaultWebRoleSlug', 'web-user'))->first();
    }
}