<?php

namespace Marcolin\Models;

use Illuminate\Database\Eloquent\Builder;

/**
 * Class Promotion
 * @package Hilco\Models
 *
 * @method static Builder active()
 */
class PromotionCurrentOrderValueTrigger extends PromotionTriggerDetails
{
    protected $table = 'PromotionCurrentOrderValueTriggers';
    protected $fillable = ['minimum_value', 'via_web', 'via_cst'];

    public function brands() {
        return $this
            ->morphedByMany(Brand::class, 'product', 'PromotionCurrentOrderValueTrigger_Product', 'PromotionCurrentOrderValueTrigger_id')
            ->withPivot(['excluded']);
    }

    public function styles() {
        return $this
            ->morphedByMany(Style::class, 'product', 'PromotionCurrentOrderValueTrigger_Product', 'PromotionCurrentOrderValueTrigger_id')
            ->withPivot(['excluded']);
    }

    public function getRelationForProductTableType($tableType) {
        //
        if ($tableType === 'webFamily' || $tableType === 'webCategory') {
            $relationName = substr($tableType, 0, -1);
            $relationName .= 'ies';
        } else {
            $relationName = $tableType . 's';
        }
        return $this->$relationName();
    }

    public function isTriggered(Customer $soldToCustomer, $webCartItems) {
        return true;
    }

    public function hasAlmostQualifyingField() {
        return true;
    }

    public function isAlmostQualifying(Customer $soldToCustomer, $webCartItems) {
        $almostQualifyingCount = $this->getCurrentQualifyingCartTotal($soldToCustomer, $webCartItems);
        return ($almostQualifyingCount >= $this->almost_qualified) ?
            $this->minimum_dollar - $almostQualifyingCount : -1;
    }

    public function getCurrentQualifyingCartTotal(Customer $soldToCustomer, $webCartItems) {
        $totalCartPrice = 0;
        foreach ($webCartItems as $webCartItem) {
            $totalCartPrice += $webCartItem->calculatedPrice;
        }

        return $totalCartPrice;
    }

}
