<?php

namespace Marcolin\Models;
use Auth;
use DB;
use Illuminate\Database\Eloquent\Model;


/**
 * Marcolin\Models\Brand
 *
 * @property integer $id
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\Brand whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\Brand whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\Brand whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\Brand whereDateUploaded($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\Brand whereDeletedAt($value)
 * @mixin \Eloquent
 */
class Brand extends Model
{
	protected $table = "Brands";

    public function customers() {
        return $this->belongsToMany(Customer::class, 'Brand_Customer');
    }

	function style() {
		return $this->belongsToMany(Style::class);
    }

    public function webBrand() {
        return $this->belongsTo(WebBrand::class);
    }

    public function getNameAttribute() {
        return $this->brandName;
    }


    public function scopeForCustomer($query, $customer = false) {
        if ($customer === false) {
            $activeCustomer = b2b()->activeCustomer();
            if ($activeCustomer) {
                $customer = $activeCustomer;
            }
        }

        if ($customer !== false) {
            $query->whereHas('customers', function ($query) use ($customer) {
                $query->where('Customers.id', '=', $customer->id);
                return $query;
            });
        }

        return $query;
    }
}
