<?php

namespace Marcolin\Models;

class WebUnit_Solr extends WebModel
{
    protected $table = 'WebUnit_Solr';
    protected $fillable = ['webUnit_id', 'hash'];

    public function item() {
        return $this->belongsTo(WebUnit::class, 'webUnit_id', 'id');
    }

    public function scopeByDeletedRecords($query) {
        return
            $query
                ->whereRaw("NOT EXISTS (SELECT 1 FROM Units JOIN WebUnits ON (Units.id = WebUnits.unit_id) WHERE WebUnits.id = webUnit_id AND WebUnits.deleted_at = '0000-00-00 00:00:00' AND Units.deleted_at = '0000-00-00 00:00:00')")
                ->whereRaw("(WebUnit_Solr.lastAction IN ('Added', 'Updated') OR WebUnit_Solr.visible != 0)")
            ;
    }
}