<?php

namespace Marcolin\Models;

/**
 * Marcolin\Models\WebLandingPage
 *
 * @property integer $id
 * @property string $name
 * @property string $date_created
 * @property string $date_modified
 * @property string $deleted_at
 * @property-read mixed $context
 * @property-read mixed $default_context
 * @property-read mixed $web_layout
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\WebLandingPage whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\WebLandingPage whereName($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\WebLandingPage whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\WebLandingPage whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\WebLandingPage whereDeletedAt($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\WebLandingPage named($name)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\WebModel joinContext($contextId = false)
 * @mixin \Eloquent
 * @property string $slug
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\WebLandingPage whereSlug($value)
 */
class WebLandingPage extends WebModel implements HasLandingPageInterface
{

    protected $table = "WebLandingPages";
    protected $fillable = ['detail'];

    public function slugUrl()
    {
        return route('landingpage.slug', [$this->slug]);
    }

    public function scopeVisible($query)
    {
        return $query;
    }

    use HasSlug, HasLandingPage;

    public static function IsExists($name = null, $slug = null)
    {
        if (!isset($name) && !isset($slug)) return true;
        $query = null;

        if (isset($name)) {
            if (!isset($query)) $query = self::named($name);
            else $query = $query->named($name);
        }

        if (isset($slug)) {
            if (!isset($query)) $query = self::where('slug', $slug);
            else $query = $query->orWhere('slug', $slug);
        }
        $result = $query->count();
        return (isset($result) && $result > 0);
    }

    public function webBrands()
    {
        return $this->belongsToMany(WebBrand::class, 'WebBrand_WebLandingPage', 'weblandingpage_id', 'webbrand_id');
    }

    public function getParentRelationName()
    {
        return false;
    }

}
