<?php

namespace Marcolin\Models;

use DB;

/**
 * Marcolin\Models\WebForms
 *
 * @property integer $id
 * @property string $title
 * @property string $slug
 * @property string $date_modified
 * @property string $deleted_at
 */
class WebFormSubmits extends WebModel
{
    protected $table = "WebFormSubmits";
    protected $fillable = ['webform_id', 'webuser_id'];

    public function form()
    {
        return $this->belongsTo(WebForms::class, 'webform_id', 'id');
    }

    public function user()
    {
        return $this->belongsTo(WebUser::class, 'webuser_id', 'id');
    }

    public function submitData()
    {
        return $this->hasMany(WebSubmitData::class, 'webformsubmit_id', 'id');
    }

}
