<?php
/**
 * Created by PhpStorm.
 * User: ntaylor
 * Date: 3/16/19
 * Time: 12:02 PM
 */

namespace Marcolin\Models;


class PromotionRedemptionLimitTrigger extends PromotionTriggerDetails {

    protected $table = 'PromotionRedemptionLimitTriggers';
    protected $fillable = ['redemption_limit', 'commit_sequence'];

    /**
     * Boolean, all promo trigger types need to implement to use their specific logic
     * @param Customer $soldToCustomer
     * @param array $webCartItems
     * @return mixed
     */
    public function isTriggered(Customer $soldToCustomer, $webCartItems = []) {
        $promotion = $this->trigger->promotion;
        $currentRedemptionsCount = PromotionRedemptions::byPromotion($promotion->id)->count();
        return $currentRedemptionsCount < $this->redemption_limit;
    }

    /**
     * promo trigger types should implement if there post operations that should happen after promo is applied
     * @param $soldToCustomer
     * @return mixed
     */
    public function postTriggerOperation(Customer $soldToCustomer)
    {
        // TODO: Implement postTriggerOperation() method.
    }

    /**
     * Boolean, any promo trigger that can use the Almost Qualifying Header should implement this and return 'true'
     * otherwise return 'false'
     * @return bool
     */
    public function hasAlmostQualifyingField()
    {
        // TODO: Implement hasAlmostQualifyingField() method.
    }

    /**
     * Any promo trigger that can use the Almost Qualifying Header should implement this and
     * @param Customer $soldToCustomer
     * @param $webCartItems
     * @return bool
     */
    public function isAlmostQualifying(Customer $soldToCustomer, $webCartItems)
    {
        // TODO: Implement isAlmostQualifying() method.
    }

}