<?php
/**
 * Created by PhpStorm.
 * User: ntaylor
 * Date: 3/16/19
 * Time: 12:18 PM
 */

namespace Marcolin\Models;

/**
 * Class PromotionCurrentOrderValueTrigger_Product
 * @package Marcolin\Models
 */
class PromotionCurrentOrderValueTrigger_Product extends WebModel {
    protected $table = 'PromotionCurrentOrderValueTrigger_Product';
    protected $fillable = [
        'promotioncurrentordervaluetrigger_id',
        'product_id', 'product_type',
        'excluded',
        'commit_sequence'
    ];

    /**
     * Gets the relationship to the owning PromotionCurrentOrderValueTrigger row
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function promotionCurrentOrderValueTrigger() {
        return $this->belongsTo(PromotionCurrentOrderValueTrigger::class,
            'promotioncurrentordervaluetrigger_id', 'id');
    }


    // Scopes
    public function scopeTriggerProduct($query, $trigger_id, $product_id, $product_type) {
        return $query->where(
            [
                'promotioncurrentordervaluetrigger_id' => $trigger_id,
                'product_id' => $product_id,
                'product_type' => $product_type
            ]
        );
    }

    use HasCommitSequence;
}