<?php

namespace Marcolin\Models;


class Datafeed extends WebModel {
    protected $table = 'Datafeeds';
    protected $fillable = [
        'id', 'name', 'marketCode', 'lensType', 'includeDiscontinued', 'includeSpecialValue',
        'includeChips', 'includeFullColor', 'includeLogos', 'isWhitelist', 'maxReleaseDate',
        'minimumInventoryLevel', 'inStock', 'enabled'
    ];

    public function brands()
    {
        return $this->belongsToMany(Brand::class, 'Datafeed_Brand', 'datafeed_id', 'brand_id');
    }

    public function datafeedFields()
    {
        return $this->belongsToMany(DatafeedField::class, 'DatafeedField_Datafeed', 'datafeed_id', 'datafeedField_id')->withPivot(['overrideName', 'enabled', 'overrideOrder']);
    }
}
