<?php

namespace Marcolin\Providers;

use Illuminate\Contracts\Events\Dispatcher as DispatcherContract;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Marcolin\Events\OrderWasPlaced;
use Marcolin\Events\UserWasRegistered;
use Marcolin\Listeners\EmailNewUserAlert;
use Marcolin\Listeners\EmailNewUserConfirmation;
use Marcolin\Listeners\EmailOrderAlert;
use Marcolin\Listeners\EmailOrderConfirmation;

class MarcolinB2BSharedEventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        OrderWasPlaced::class => [
            EmailOrderAlert::class,
            EmailOrderConfirmation::class,
        ],
        UserWasRegistered::class => [
            EmailNewUserAlert::class,
            EmailNewUserConfirmation::class,
        ],
    ];

    /**
     * Register any other events for your application.
     *
     * @param  \Illuminate\Contracts\Events\Dispatcher $events
     * @return void
     */
    public function boot(DispatcherContract $events)
    {
        parent::boot($events);
    }
}
