<?php

namespace Marcolin\Models;

use DB;


class SalesRep extends WebModel
{
    protected $table = "SalesReps";

    public function brands()
    {
        return $this->belongsToMany(Brand::class, 'SalesRep_Customer_Brand', 'salesrep_id', 'brand_id')->distinct();
    }

    public function salesDistrict()
    {
        return $this->belongsToMany(SalesDistrict::class, 'SalesRep_Customer_Brand', 'salesrep_id', 'salesDistrict_id')->withPivot('brand_id');
    }
}
