<?php

namespace Marcolin\Models;

use Auth;
use DB;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;


/**
 * Marcolin\Models\Brand
 *
 * @property integer $id
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\Brand whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\Brand whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\Brand whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\Brand whereDateUploaded($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\Brand whereDeletedAt($value)
 * @mixin \Eloquent
 */
class CreditStatement extends Model
{
    protected $table = "CreditStatements";

    public function customers()
    {
        return $this->hasMany(Customer::class, 'customerCode_id', 'customerCode_id');
    }

    public function scopeInvoice(Builder $query)
    {
        return $query->where('description', 'Inv');
    }
}
