<?php

namespace Marcolin\Models;

use Illuminate\Database\Eloquent\Collection;

class WebRole extends WebModel
{

    protected $table = 'WebRoles';
    protected $fillable = ['name', 'slug', 'description', 'is_enabled'];
    protected $with = ['webPermissions'];

    public function webUsers()
    {
        return $this->belongsToMany(WebUser::class, 'WebRole_WebUser');
    }

    public function webPermissions()
    {
        return $this->belongsToMany(WebPermission::class, 'WebPermission_WebRole', 'webrole_id', 'webpermission_id');
    }

    public function managingWebPermissions()
    {
        return $this->belongsToMany(WebPermission::class, 'WebPermission_ManagedWebRole', 'managedWebRole_id', 'webPermission_id');
    }

    public function managedWebRoles()
    {
        return $this->belongsToMany('Marcolin\Models\WebRole', 'WebRole_ManagedWebRole', 'webRole_id', 'managedWebRole_id');
    }

    public function cmsPermissions()
    {
        return $this->webPermissions()->where('slug','LIKE','cms-%');
    }

    public static function getDefault()
    {
        return WebRole::where('slug', config('marcolin.defaultWebRoleSlug', 'web-user'))->first();
    }
}