<?php

namespace Marcolin\Models;

use DB;
use Marcolin\Models\SelectsRelatedCount;
use Venturecraft\Revisionable\RevisionableTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class WebAttribute extends Model
{
	use \Marcolin\SoftDeletes;

	const CREATED_AT = 'date_created';
	const UPDATED_AT = 'date_modified';

	protected $table = 'WebAttributes';
	protected $fillable = ['attribute_name'];

	public function webUnits() {
		return $this->belongsToMany(WebUnit::class, 'WebAttribute_WebUnit', 'webattribute_id', 'webunit_id')->withPivot(['attribute_value']);
	}

	public function webStyles() {
		return $this->belongsToMany(WebStyle::class, 'WebAttribute_WebStyle', 'webattribute_id', 'webfamily_id');
	}

	public function values() {
		return $this->hasMany(WebAttribute_WebUnit::class, 'webattribute_id', 'id');
	}

	public function getValuesInCategoryAttribute() {
		return $this->webUnits->sortBy('pivot.attribute_value')->pluck('pivot.attribute_value', 'pivot.attribute_value');
	}

	public function scopeInCollection($query, $webCollection) {
		$webCollectionId = ($webCollection instanceof WebBrand) ? $webCollection->id : $webCollection;
		return $query->whereHas('webStyles', function ($query) use ($webCollectionId) {
			return $query->inCollection($webCollectionId);
		});
	}

	public function scopeInCategory($query, $webCategory) {
		$webCategoryId = ($webCategory instanceof WebCategory) ? $webCategory->id : $webCategory;
		return $query->whereHas('webStyles', function ($query) use ($webCategoryId) {
			return $query->inCategory($webCategoryId);
		});
	}

	public function scopeInGroup($query, $webBrand) {
		$webBrandId = ($webBrand instanceof WebBrand) ? $webBrand->id : $webBrand;
		return $query->whereHas('webStyles', function ($query) use ($webBrandId) {
			return $query->inGroup($webBrandId);
		});
	}

	public static function in($model) {
		if ($model instanceof WebBrand) {return self::inGroup($model);}
		else if ($model instanceof WebCategory) return self::inCategory($model);
		else if ($model instanceof WebBrand) return self::inCollection($model);
	}

	use RevisionableTrait;
}
