<?php

namespace Marcolin\Models;

use Auth;
use DB;
use Image as Image2;
use Storage;

/**
 * Marcolin\Models\Product
 *
 * @property mixed $id
 */
class Customer extends WebModel
{
	protected $table = 'Customers';

    public function brands() {
        return $this->belongsToMany(Brand::class, 'Brand_Customer')->webVisible();
    }

    public function salesDistrict() {
        return $this->belongsTo(SalesDistrict::class, 'salesDistrict_id', 'id');
    }

    public function allSalesReps() {
        return $this->salesDistrict()->first()->salesReps();
    }
    public function activeSalesReps() {
        $brands = $this->brands->pluck('id');
        return $this->salesDistrict()->first()->salesReps()
            ->whereIn('SalesRep_Customer_Brand.brand_id', $brands)
            ;
    }

	public function salesData() {
	    return $this->hasMany(SalesData::class, 'customer_id', 'id');
    }

    public function orders() {
        return $this->hasMany(Order::class, 'soldTo_customer_id', 'id');
    }

    public function lastOrderedStyle($style) {
	    return $this->orderHistories->where('style', $style)->sortByDesc('billingDate')->first();
    }

    public function getFormattedTelephoneAttribute() {
        return preg_replace('~.*(\d{3})[^\d]{0,7}(\d{3})[^\d]{0,7}(\d{4}).*~', '($1) $2-$3', $this->telephone). "\n";
    }

    public function getFormattedTelephone2Attribute() {
        return preg_replace('~.*(\d{3})[^\d]{0,7}(\d{3})[^\d]{0,7}(\d{4}).*~', '($1) $2-$3', $this->telephone2). "\n";
    }

    public function getLockedBrands() {
        $brands = $this->brands->pluck('id');
        $lockedBrands = Brand::webVisible()->whereNotIn('id', $brands)->where('deleted_at', '=', '0000-00-00')->orderBy('brandName')->get();
        return $lockedBrands;
    }

    public function recentOrders($count = 5) {
        return $this
            ->orders()
//            ->submitted()
            ->with('orderItems')
            ->orderByDate()
            ->take($count)
            ->get();
    }

    public function topPurchasedItems($count = 5) {
        $data = $this
            ->salesData()
            ->with('unit.webUnit.webStyle')
            ->where(function ($wheres) {
                return $wheres
                    ->where('qtyB2B', '>', DB::raw(0))
                    ->orWhere('qtyIPad', '>', DB::raw(0))
                ;
            })
            ->whereHas('unit', function ($query) {
                return $query->whereHas('styleRelation', function ($query) {
                    return $query->whereHas('webStyle', function ($query) {
                        return $query->webVisible();
                    });
                });
            })
            ->groupBy('SalesData.id')
            ->orderBy('documentDate', 'desc')
            ->take($count)
            ->get()
        ;

        $styleIds = [];
        foreach ($data as $record) {
            $styleId = array_get($record, 'unit.webUnit.webStyle.id');
            $styleIds[$styleId] = $styleId;
        }
        return WebStyle::findMany($styleIds);
    }
}

