<?php

namespace Hilco\Models;

use Hilco\SoftDeletes;


/**
 * Hilco\Models\FOB
 *
 * @property integer $id
 * @property string $fob_code
 * @property string $fob_desc
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @mixin \Eloquent
 */
class SalesOrder extends UuidModel
{
    protected $table = "SalesOrders";

    use SoftDeletes;

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function getTotalQuantityAttribute()
    {
        $totalQuantity = 0;
        foreach ($this->salesOrderItems as $salesOrderItem) {
            $totalQuantity += $salesOrderItem->quantity;
        }
        return $totalQuantity;
    }

    public function salesOrderItems()
    {
        return $this->hasMany(SalesOrderItem::class, 'salesOrder_id', 'id');
    }

    public function salesOrderNotes()
    {
        return $this->hasMany(SalesOrderNote::class, 'salesOrder_id', 'id');
    }

    public function scopeDateBetween($query, $fromDate, $toDate = false)
    {
        if ($toDate === false) {
            $query->where('orderDate', '>=', $fromDate);
        } else {
            $query->whereBetween('orderDate', [$fromDate, $toDate]);
        }
        return $query;
    }

    public function scopeWebOrders($query)
    {
        return $query->where('orderType', 'B');
    }
}
