<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 1/19/2017
 * Time: 10:35 AM
 */

namespace Marcolin\Listeners;

use Illuminate\Support\Facades\Mail;
use Marcolin\Events\OrderWasPlaced;

/**
 * Sends an email to customer service to alert that a new order was placed.
 *
 * Class EmailOrderAlert
 * @package Marcolin\Listeners
 */
class EmailOrderAlert
{
    public function construct()
    {

    }

    public function handle($event)
    {
        Mail::send('marcolin::emails.orders.submitted', ['order' => $event->order], function ($email) use ($event) {
            foreach (config('marcolin.emailDestinations.orderAlert.to', []) as $to) {
                if (strlen($to)) $email->to($to);
            }

            foreach (config('marcolin.emailDestinations.orderAlert.bcc', []) as $bcc) {
                if (strlen($bcc)) $email->bcc($bcc);
            }

            $email->from(config('mail.from_orders.address'), config('mail.from_orders.name'));

            if ($event->order->orderType === 'B') {
                $email->subject(trans('marcolin::email.orderAlertSubjectB2B', ['orderNumber' => $event->order->orderNumber, 'customerNumber' => $event->order->customer->customerCode]));
            } else {
                $email->subject(trans('marcolin::email.orderAlertSubjectESB', ['orderNumber' => $event->order->orderNumber, 'customerNumber' => $event->order->customer->customerCode]));
            }
        });
    }
}