<?php

namespace Marcolin\Providers;

use App;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\ServiceProvider;
use Illuminate\View\View;
use Marcolin\Models\AutocatCatalogItem;
use Marcolin\Models\Customer;
use Marcolin\Models\Promotion;
use Marcolin\Models\WebAsset;
use Marcolin\Models\UACReportModuleInstanceAlertTrigger;
use Marcolin\Models\UACReportModuleInstanceSavedFilter;
use Marcolin\Models\WebPromotion;
use Marcolin\Models\WebCart;


class MarcolinB2BSharedProvider extends ServiceProvider
{
    public function register()
    {
        $this->mergeConfigFrom(__DIR__ . '/../../config/marcolin.php', 'marcolin');
        $this->mergeConfigFrom(__DIR__ . '/../../config/creditcards.php', 'creditcards');

        $this->app->singleton('b2b', function () {
            return new \Marcolin\B2BHelper();
        });
    }

    public function boot()
    {
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'marcolin');

        $this->publishes([
            __DIR__ . '/../../config/layoutcomponents.php' => config_path('layoutcomponents.php')
        ], 'marcolin-shared');

        $this->publishes([
            __DIR__ . '/../../config/marcolin.php' => config_path('marcolin.php')
        ], 'marcolin');

        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'marcolin');

        Relation::morphMap(WebAsset::getMorphMap());
        Relation::morphMap(WebPromotion::getMorphMap());
        Relation::morphMap(UACReportModuleInstanceAlertTrigger::getMorphMap());
        Relation::morphMap(UACReportModuleInstanceSavedFilter::getMorphMap());
        Relation::morphMap(AutocatCatalogItem::getMorphMap());
        Relation::morphMap([
            'customer' => Customer::class,
        ]);
        Relation::morphMap(WebCart::getMorphMap());

        view()->creator('marcolin::components.*', function (View $view) {
            $data = $view->getData();
            if (!array_has($data, 'edit')) $view->with('edit', false);
            if (!array_has($data, 'wrap')) $view->with('wrap', false);
            if (!array_has($data, 'script')) $view->with('script', false);
            if (!array_has($data, 'view')) $view->with('view', false);
        });

        foreach (config('marcolin.components', []) as $key => $component) {
            view()->creator($component['view'], function (View $view) use ($component) {
                $viewData = $view->getData();
                $compData = array_dot($component['defaultViewData']);
                foreach ($compData as $kk => $vv) {
                    if (!array_has($viewData, $kk)) array_set($viewData, $kk, $vv);
                }
                $view->with($viewData);
            });
        }

//        Blade::directive('pushonce', function ($expression) {
//            $array = explode(':', trim(substr($expression, 2, -2)));
//            $pushType = $array[0];
//            $pushId = $array[1];
//            $isDisplayed = "__pushonce__{$pushType}__{$pushId}";
/*            return "<?php if (!isset(\$__env->{$isDisplayed})): \$__env->{$isDisplayed} = true; \$__env->startPush('{$pushType}'); ?>";*/
//        });
//
//        Blade::directive('endpushonce', function ($expression) {
/*            return '<?php $__env->stopPush(); endif; ?>';*/
//        });
    }
}