<?php

namespace Marcolin\Models;

use DB;


class B2BReturn extends WebModel
{
    protected $table = "B2BReturns";

    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customer_id', 'id');
    }

    public function b2bReturnItems()
    {
        return $this->hasMany(B2BReturnItem::class, 'b2breturn_id', 'id');
    }

    public function scopeWorkingReturn($query)
    {
        return $query->whereNotNull('date_entered');
    }
}
