@if($edit)
    <div class="mceNonEditable component-container" data-component-key="autocat_catalog">
        <a href="#" class="btn btn-danger pull-right delete-component">X</a>
        <h4>Autocat Catalog</h4>
        <p>Displays the items from an AutoCat catalog.</p>
        <button id="autocat_catalog_select">Select a Catalog</button>
        <input type="hidden" id="catalog-id">
    </div>
@endif

@if($script)
    <script type="text/javascript">
        registerComponent('autocat_catalog', {
            menuText: 'Autocat Catalog',
            bladeTemplate: 'marcolin::components.autocat_catalog',
            init: function (body) {
                $(body).on('click', '#autocat_catalog_select', function () {
                    swal({
                        title: 'Select a Catalog',
                        input: 'select',
                        inputOptions: {
                            @foreach(\Marcolin\Models\AutocatCatalog::where('autocatlayout_id', '=', 2)->get() as $catalog)
                                {{ $catalog->id }} : '{{ $catalog->name }}',
                            @endforeach
                        },
                        inputPlaceholder: 'Select a Catalog',
                        showCancelButton: true,
                    }).then(function (result) {
                        $(body).find('input#catalog-id').attr('data-catalog-id', result);
                    });
                });
            },
            serialize: function (componentNode) {
                return {
                    autocat_catalog_id: $(componentNode).find('input#catalog-id').data('catalog-id')
                }
            },
        });
    </script>
@endif

@if($view)

    <div class="row" id="search">
        <div class="col-md-6 col-lg-offset-3">
            <div class="panel panel-default">
                <div class="panel-body">
                    <div id="styles" class="panel-body">
                        <div class="styles-list-container" id="catalog_div">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <br>

    <style type="text/css">
        .pagination .ais-pagination--item__disabled {
            visibility: visible !important;
        }

        .style-list-item-container .style-name {
            font-size: 14pt;
            font-weight: bold;
        }

        .style-list-item-container .style-brand {
            margin-left: 20px;
        }

        .style-list-item-container .style-icons {
            float: right;
            font-size: 12pt;
            padding-bottom: 5px;
        }

        .style-list-item-container .style-info {
            float: left;
            margin-right: 20px;
        }

        .style-list-item-container .style-info .form-group {
            margin-right: 10px;
        }

        .style-list-item-container .style-info > span:not(.style-icon) {
            margin-right: 20px;
        }

        .style-list-item-container .style-icon > *:first-child {
            margin-right: 20px;
        }

        .style-list-item-container .style-size {
            display: inline-block;
            margin-right: 20px;
        }

        .style-list-item-container .style-quantity-add {
            display: inline-block;
            margin-right: 20px;
        }

        .style-list-item-container .style-price {
            font-size: 12pt;
            font-weight: bold;
        }


        .style-list-item-container .style-colors {
            overflow: hidden;
        }

        .style-list-item-container .style-unit {
            padding-bottom: 12px;
        }

        .style-list-item-container .panel.selected {
            border-color: #0cbeff;
        }

        .style-list-item-container .style-selected-unit {
            font-size: 9pt;
        }
    </style>

    <script type="text/javascript">
        $(document).ready(function () {
            $('body').on('click', '.style-unit', function () {
                var styleId = $(this).closest('.style-list-item-container').attr('data-style-id');
                selectColor(styleId, $(this).find('.unit-thumbnail').attr('data-unit-color'));
            }).on('change', '.style-selected-color', function () {
                var styleId = $(this).closest('.style-list-item-container').attr('data-style-id');
                selectColor(styleId, $(this).val());
            }).on('click', '.unit-size-radio', function () {
                var styleId = $(this).closest('.style-list-item-container').attr('data-style-id');
                selectSize(styleId, $(this).val());
            }).on('click', '.add-to-cart-button', function () {
                var $container = $(this).closest('.style-list-item-container');
                var styleId = $container.attr('data-style-id');
                var quantity = $container.find('#quantity').val();
                var unitId = getSelectedUnitId(styleId);

                var $button = $(this);
                $button.html($button.data('loading-text'));
                addUnitToCart(unitId, quantity, function() {
                    $button.html($button.data('complete-text'));
                    setTimeout(function () {
                        $button.html($button.data('normal-text'));
                    }, 2000);
                });
                return false;
            }).on('click', '.request-access-button', function () {
                var $container = $(this).closest('.style-list-item-container');
                var brandName = $container.attr('data-brand-name');
                var brand_id = $container.attr('data-brand-id');

                swal({
                    text: 'Thank you for your interest in '+brandName+' if you would like to buy in or obtain more information click the link below.',
                    showCancelButton: true,
                    confirmButtonText: 'Request Activation',
                    cancelButtonText: 'Cancel',
                }).then(function () {
                    $.post("/profile/requestBrand", {
                        brand_id: brand_id,
                        '_token': _csrf_token
                    }, function (data) {
                        swal({
                            text: 'Request sent.',
                            timer: 1000
                        }).then(
                            function () {},
                            function (dismiss) {}
                        )
                    });
                }, function (dismiss) {
                });
            });

            $.ajax({
                url: '/ac/{{ $autocat_catalog_id }}',
                type: 'POST',
                data: {
                    _token: _csrf_token,
                },
                success: function (data) {
                    $('#catalog_div').html(data);

                    $('[title]').qtip({
                        style: {
                            classes: 'qtip-bootstrap'
                        },
                        position: {
                            viewport: $(window),
                        },
                    });

                    $('.style-list-item-container').each(function () {
                        var colorCode = $(this).find('[data-unit-color]').first().attr('data-unit-color');
                        selectColor($(this).attr('data-style-id'), colorCode);
                    });
                },
                complete: function () {

                }
            });
        });

        function selectColor(styleId, colorCode) {
            var $container = $('.style-list-item-container[data-style-id="' + styleId + '"]');
            $container.find('.unit-image').hide().filter('[data-unit-color="' + colorCode + '"]').show();

            var $thumbnails = $container.find('.unit-thumbnail');
            $thumbnails.closest('.panel').removeClass('selected');
            $thumbnails.filter('[data-unit-color="' + colorCode + '"]').closest('.panel').addClass('selected');

            $container.find('.style-selected-color').val(colorCode);

            var selectedSize = getSelectedSize(styleId);
            var validSizes = [];
            var validSize = false;
            $('#quick-order-' + styleId + ' [data-unit-id]').each(function (index, unit) {
                var size = $(unit).attr('data-unit-size');
                if (size == selectedSize) {
                    validSize = true;
                    validSizes.push(size)
                }
            });

            if (!validSize) {
                selectSize(styleId, validSizes[0]);
            } else {
                updateUnit(styleId);
            }
        }

        function updateUnit(styleId) {
            var size = getSelectedSize(styleId);
            var color = getSelectedColor(styleId);
            var $unit = $('#quick-order-' + styleId + ' input[data-unit-color="' + color + '"][data-unit-size="' + size + '"]');

            if ($unit.length) {
                $('.style-list-item-container[data-style-id="' + styleId + '"]').find('.style-stock').text($unit.attr('data-unit-stock'));
                @if(canUser('b2b-prices'))
                    $('.style-list-item-container[data-style-id="' + styleId + '"]').find('.style-price').text($unit.attr('data-unit-price'));
                @endif
            }
        }

        function getSelectedSize(styleId) {
            var $container = $('.style-list-item-container[data-style-id="' + styleId + '"]');
            return $container.find('.unit-size-radio:checked').first().val();
        }

        function getSelectedColor(styleId) {
            return $('#colors-' + styleId).val();
        }

        function getSelectedUnitId(styleId) {
            var size = getSelectedSize(styleId);
            var color = getSelectedColor(styleId);
            var $unit = $('#quick-order-' + styleId + ' input[data-unit-color="' + color + '"][data-unit-size="' + size + '"]');
            return $unit.attr('data-unit-id');
        }

        function selectSize(styleId, size) {
            var selectedColor = getSelectedColor(styleId);

            var validColors = [];
            var validColor = false;
            $('#quick-order-' + styleId + ' [data-unit-id]').each(function (index, unit) {
                var color = $(unit).attr('data-unit-color');
                if (color == selectedColor) {
                    validColor = true;
                    validColors.push(color);
                }
            });

            if (!validColor) {
                selectColor(styleId, validColors[0]);
            } else {
                updateUnit(styleId);
            }
        }

        function getTemplate(templateName) {
            return document.getElementById(templateName + '-template').innerHTML;
        }
    </script>
@endif
