<?php

namespace Marcolin\Models;

use DB;

class UACReportModuleInstanceSavedFilter extends WebModel
{
    protected $table = "UACReportModuleInstanceSavedFilters";

    protected $fillable = ['uacreportmoduleinstance_id', 'filter_name', 'filter_id', 'filter_type'];

    protected static $morphMap = [
        'dateRange' => UACReportModuleInstanceDateRangeFilter::class,
        'text' => UACReportModuleInstanceTextFilter::class,
    ];

    /**
     * Get the morph mapping of filter/action types to their actual class models
     * @return array
     */
    public static function getMorphMap() {
        return self::$morphMap;
    }

    public static function boot() {
        parent::boot();
        // Create a row for the actual filter before creating the polymorphic relationship row in UACReportModuleInstanceSavedFilter
        static::created(function (UACReportModuleInstanceSavedFilter $filter) {
            $className = $filter->getActualClassNameForMorph($filter->filter_type);
            $details = $className::create();
            $filter->details()->associate($details);
            $filter->save();
        });
        // Delete the row for the actual filter when deleting the polymorphic relationship row in UACReportModuleInstanceSavedFilter
        static::deleted(function (UACReportModuleInstanceSavedFilter $filter) {
            $details = $filter->details;
            $details->delete();
        });
    }

    public function uacReportModuleInstance() {
        return $this->belongsTo(UACReportModuleInstance::class, 'uacreportmoduleinstance_id', 'id');
    }
    
    public function details() {
        return $this->belongsTo($this->getActualClassNameForMorph($this->filter_type), 'filter_id', 'id');
    }
}
