<?php

namespace Marcolin\Models;

use DB;

class UACReportModuleInstanceDateRangeFilter extends WebModel
{
    protected $table = "UACReportModuleInstanceDateRangeFilters";

    protected $fillable = ['value'];

    public function getStartTimeAttribute() {
        if ($this->value == 'last7days') {
            return date('Y-m-d', strtotime('-7 days'));
        } else if ($this->value == 'last30days') {
            return date('Y-m-d', strtotime('-30 days'));
        } else if ($this->value == 'last3months') {
            return date('Y-m-d', strtotime('-3 months'));
        } else if ($this->value == 'last6months') {
            return date('Y-m-d', strtotime('-6 months'));
        } else if ($this->value == 'lastyear') {
            return date('Y-m-d', strtotime('-1 years'));
        } else if ($this->value == 'ytd') {
            return date('Y-01-01');
        } else if ($this->value == 'all') {
            return date('Y-m-d', strtotime('-10 years'));
        }
        return date('Y-m-d');
    }

    public function getEndTimeAttribute() {
        return date('Y-m-d');
    }

    public function getFormattedTextAttribute() {
        if ($this->value == 'last7days') {
            return 'Last 7 Days';
        } else if ($this->value == 'last30days') {
            return 'Last 30 Days';
        } else if ($this->value == 'last3months') {
            return 'Last 3 Months';
        } else if ($this->value == 'last6months') {
            return 'Last 6 Months';
        } else if ($this->value == 'lastyear') {
            return 'Last Year';
        } else if ($this->value == 'ytd') {
            return 'YTD';
        } else if ($this->value == 'all') {
            return 'All';
        }
        return 'N/A';
    }
}
