<?php

namespace Marcolin\Models;

use Auth;
use DB;
use Illuminate\Support\Facades\Log;

class PPECart extends WebModel
{
    protected $table = 'PPECarts';
    protected $fillable = ['quantity', 'itemNote', 'shippingMethod', 'customeraddress_id'];

    public function unit()
    {
        return $this->belongsTo(Unit::class, 'unit_id', 'id');
    }

    public function webUnit() {
        return $this->belongsTo(WebUnit::class, 'unit_id', 'unit_id');
    }

    public function webUser()
    {
        return $this->belongsTo(WebUser::class);
    }

    public function customerAddress()
    {
        return $this->belongsTo(CustomerAddress::class, 'customeraddress_id', 'id');
    }

    public function scopeForUser($query, $webuserId)
    {
        return $query->where('webuser_id', $webuserId);
    }

    public function getExtendedPrice($customer = null)
    {
        return $this->unit->getCustomerPrice($customer) * $this->quantity;
    }

    public static function add(Unit $unit, $quantity = 1, $trayinfo = null) {
        $instance = new static;

        $instance->webuser_id = Auth::id();
        $instance->unit_id = $unit->id;
        $instance->quantity = $quantity;
        $instance->itemNote = $trayinfo;

        $soldToCustomer = b2b()->activeCustomer();
        $instance->shippingMethod = $soldToCustomer->preferredShippingMethodCode;

        if($soldToCustomer->defaultShippingAddress != null){
            $instance->customerAddress_id = $soldToCustomer->defaultShippingAddress->id;
        }else{
            $instance->customerAddress_id = null;
            Log::error("Customer doesn't have a deafult shipping address. ID-".$soldToCustomer->id);
        }
        

        $instance->save();
        return $instance;
    }

    public static function remove($userId, $unit_id)
    {
        $instance = new static;
        return $instance::where(['unit_id' => $unit_id, 'webuser_id' => $userId])->delete();
    }

    public static function cartItems($webUserId = false, $billToCustomerSegmentId = false) {
        // Get the web user. If and ID is provided, use it, otherwise, use who ever is logged in.
        if ($webUserId === false)
            $webUser = auth()->user();
        else
            $webUser = WebUser::find($webUserId);

        if (is_null($webUser)) return [];

        // Get the sold to customer.
        $soldToCustomer = b2b()->activeCustomer();

        $cartItems = self::forUser($webUser->id)
            ->has("unit")
            ->with([
                'unit' => function ($query) {
                    return $query
                        ->with([
//                            'unitMarkets',
                            'webUnit' => function ($query) {
                                return $query
                                    ->with([
                                        'assets',
                                        'webStyle',
                                    ]);
                            },
                            'webStyle' => function ($query) {
                                return $query
                                    ->with([
                                        'style',
                                    ]);
                            }
                        ]);
                },
            ])
            ->get();

        $priceOverrideAction = false;
        if (b2b()->activePromotion() && b2b()->activePromotion()->isQualifying($soldToCustomer, $cartItems)) {
            $priceOverrideAction = b2b()->activePromotion()->priceOverrideActions()->first();
        }

        foreach ($cartItems as $key => $cartItem) {
            $cartItems[$key]->customerPrice = $cartItem->unit->getCustomerPrice($soldToCustomer);
            $cartItems[$key]->discountPercent = $cartItem->unit->getCustomerDiscount($soldToCustomer);

            if ($priceOverrideAction && $priceOverrideAction->isApplicable($cartItem->unit)) {
                $cartItems[$key]->discountedPrice = $priceOverrideAction->override_amount;
            } else if ($cartItems[$key]->discountPercent > 0) {
                $cartItems[$key]->discountedPrice = round($cartItems[$key]->customerPrice - ($cartItems[$key]->customerPrice * ($cartItems[$key]->discountPercent / 100)), 2);
            } else {
                $cartItems[$key]->discountedPrice = $cartItems[$key]->customerPrice;
            }

            $cartItems[$key]->calculatedPrice = $cartItems[$key]->discountedPrice * $cartItems[$key]->quantity;
        }
        return $cartItems;
    }
    
}
