<?php
/**
 * Created by PhpStorm.
 * User: brian
 * Date: 3/21/19
 * Time: 12:35 PM
 */

namespace Marcolin\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Trait HasModelTranslations
 * @package Marcolin\Models
 */
trait HasModelTranslations {

    protected $queuedTranslations = [];

    public static function bootHasModelTranslations() {
        static::created (function (Model $translatableModel) {
            foreach ($translatableModel->queuedTranslations as $translationInfo) {
                $translatableModel->setTranslation($translationInfo['language'], $translationInfo['column_name'], $translationInfo['translation']);
            }
            $translatableModel->queuedTranslations = [];
        });
    }

    public function translations() {
        return $this->morphMany(WebModelTranslation::class, 'translatable');
    }

    public function getTranslation($columnName, $language = false, $default = false) {
        if ($language === false) $language = b2b()->activeLanguage();
        if ($default === false) $default = array_get($this->attributes, $columnName, '');
        $translation = $this->translations->where('language', $language)->where('column_name', $columnName)->first();
        return array_get($translation, "translation", $default);
    }

    public function deleteTranslation($columnName, $language){
        $this->translations->where('language', $language)->where('column_name', $columnName)->first()->delete();
    }

    public function setTranslation($language, $columnName, $translation) {
        if (!$this->exists) {
            $this->queuedTranslations[] = [
                'language' => $language,
                'column_name' => $columnName,
                'translation' => $translation
            ];
        } else {
            $modelTranslation = $this->translations()->withTrashed()->where('language', $language)->where('column_name', $columnName)->first();
            if(!empty($modelTranslation)){
                $modelTranslation->restore();
            }
            $this->translations()
                ->updateOrCreate(
                    [
                        'language' => $language,
                        'column_name' => $columnName
                    ],
                    [
                        'translation' => $translation
                    ]
                )
            ;
        }
    }

    protected static $morphMap = [
        'webBrand'                  => WebBrand::class,
        'style'                   => Style::class,
        'unit'               => Unit::class,
    ];

    /**
     * Get the morph mapping of trigger/action types to their actual class models
     * @return array
     */
    public static function getMorphMap() {
        return self::$morphMap;
    }
}