@if($edit)
    <div class="mceNonEditable component-container" data-component-key="promoBanners">
        <a href="#" class="btn btn-danger pull-right delete-component">X</a>
        <h4>Qualified Promotions</h4>
        <p>Displays promotion banner(s) across the entire width of the page in carousel.</p>
    </div>
@endif

@if($script)
    <script type="text/javascript">
        registerComponent('promoBanners', {
            menuText: 'Qualified Promotions',
            bladeTemplate: 'marcolin::components.promoBanners',
            init: function (body) {
            },
            serialize: function (componentNode) {
                return {};
            },
        });
    </script>
@endif

@if($view)
    <div id="qualified-promotions-carousel" class="owl-carousel owl-theme">
        @foreach(array_get($cartStatus, 'displayPromotions', []) as $promotion)
            @if (strlen($promotion->homepage_banner_text))
                <div class="alert text-center" style="background-color: #003f5f; color: white; font-size: 14pt;">
                    @if (strlen($promotion->homepage_banner_link))
                        <a style="color: white;" href="{!! $promotion->homepage_banner_link !!}"><strong>{!! $promotion->homepage_banner_text !!}</strong></a>
                    @else
                        <strong>{!! $promotion->homepage_banner_text !!}</strong>
                    @endif
                </div>
            @endif
        @endforeach
    </div>

    <script type="text/javascript">
        $(document).ready(function () {
            $('#qualified-promotions-carousel').owlCarousel({
                center: true,
                items: 1,
                @if(count(array_get($cartStatus, 'displayPromotions', [])) > 1)
                    loop: true,
                @endif
                autoplay: true,
                autoplayTimeout: {{ isset($bannerTimeout) ? $bannerTimeout : '3000' }},
                autoplayHoverPause: true,
                dots: true,
            });
        });
    </script>
@endif