<?php

namespace Marcolin\Models;
use Marcolin\SoftDeletes;

/**
 * Marcolin\Models\SalesOrder_EmailSent
 *
 * @property integer $id
 * @property int $emailSent
 * @property string $date_created
 * @property string $date_modified
 * @property string $deleted_at
 * @mixin \Eloquent
 */
class SalesOrder_EmailSent extends WebModel
{
	protected $table = "SalesOrder_EmailSent";

    use SoftDeletes;

    public function salesOrder() {
        return $this->belongsTo(SalesOrder::class, 'salesOrder_id', 'id');
    }

    public static function createEmailSent($order) {
        $emailSent = new SalesOrder_EmailSent;
        $emailSent->emailSent = 1;
        $emailSent->salesOrder_id = $order->id;
        $emailSent->save();
        return $emailSent;
    }

}
