<?php

namespace Marcolin\Models;

use DB;
use Marcolin\SoftDeletes;


/**
 * Marcolin\Models\FOB
 *
 * @property integer $id
 * @property string $fob_code
 * @property string $fob_desc
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @mixin \Eloquent
 */
class SalesOrderItem extends UuidModel
{
    protected $table = "SalesOrderItems";

    use SoftDeletes;

    public function salesOrder()
    {
        return $this->belongsTo(SalesOrder::class, 'salesOrder_id', 'id');
    }

    public function unit()
    {
        return $this->belongsTo(Unit::class)->withTrashed();
    }
}
