<?php

namespace Marcolin\Models;

/**
 * Class PromotionCurrentOrderQuantityTrigger_Product
 * @package Marcolin\Models
 */
class PromotionCurrentOrderQuantityTrigger_Product extends WebModel {
    protected $table = 'PromotionCurrentOrderQuantityTrigger_Product';
    protected $fillable = [
        'promotioncurrentorderquantitytrigger_id',
        'product_id', 'product_type',
        'excluded',
        'commit_sequence'
    ];

    /**
     * Gets the relationship to the owning PromotionCurrentOrderQuantityTrigger row
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function promotionCurrentOrderValueTrigger() {
        return $this->belongsTo(PromotionCurrentOrderQuantityTrigger::class,
            'promotioncurrentorderquantitytrigger_id', 'id');
    }


    // Scopes
    public function scopeTriggerProduct($query, $trigger_id, $product_id, $product_type) {
        return $query->where(
            [
                'promotioncurrentorderquantitytrigger_id' => $trigger_id,
                'product_id' => $product_id,
                'product_type' => $product_type
            ]
        );
    }

    use HasCommitSequence;
}
