<?php

namespace Marcolin\Models;

class PromotionCustomerTrigger extends PromotionTriggerDetails
{
    protected $table = 'PromotionCustomerTriggers';
    protected $fillable = ['target_all_customers'];

    public function customers()
    {
        return $this->belongsToMany(Customer::class, 'PromotionCustomerTrigger_Customer', 'promotioncustomertrigger_id', 'customer_id')
            ->withPivot(['excluded', 'redeemed']);
    }

    public function isTriggered(Customer $soldToCustomer, $webCartItems)
    {
        $customer = $this->customers()->wherePivot('customer_id', '=', $soldToCustomer->id)->first();
        return !is_null($customer);
    }
}
