<?php

namespace Marcolin\Models;

use Illuminate\Database\Eloquent\Builder;

/**
 * Class Promotion
 * @package Hilco\Models
 *
 * @method static Builder active()
 */
class PromotionCurrentOrderQuantityTrigger extends PromotionTriggerDetails
{
    protected $table = 'PromotionCurrentOrderQuantityTriggers';
    protected $fillable = ['minimum_quantity', 'any_product'];

    public function webBrands()
    {
        return $this
            ->morphedByMany(WebBrand::class, 'product', 'PromotionCurrentOrderQuantityTrigger_Product', 'PromotionCurrentOrderQuantityTrigger_id')
            ->withPivot(['excluded'])
            ->whereNull('PromotionCurrentOrderQuantityTrigger_Product.deleted_at');
    }

    public function getRelationForProductTableType($tableType)
    {
        //
        if ($tableType === 'webFamily' || $tableType === 'webCategory') {
            $relationName = substr($tableType, 0, -1);
            $relationName .= 'ies';
        } else {
            $relationName = $tableType . 's';
        }
        return $this->$relationName();
    }

    public function isTriggered(Customer $soldToCustomer, $webCartItems)
    {
        return true;
    }
}
