<?php

namespace Marcolin\Models;

use DB;

class UACReportModuleInstanceAlertTrigger extends WebModel
{
    protected $table = "UACReportModuleInstanceAlertTriggers";

    protected $fillable = ['uacreportmoduleinstancealert_id', 'trigger_id', 'trigger_type', 'trigger_name'];

    protected static $morphMap = [
        'fixedCellValue' => UACReportModuleInstanceAlertFixedCellValueTrigger::class,
        'contextSensitive' => UACReportModuleInstanceAlertContextSensitiveTrigger::class,
    ];

    /**
     * Get the morph mapping of trigger/action types to their actual class models
     * @return array
     */
    public static function getMorphMap() {
        return self::$morphMap;
    }

    public static function boot() {
        parent::boot();
        // Create a row for the actual filter before creating the polymorphic relationship row in UACReportModuleInstanceSavedFilter
        static::created(function (UACReportModuleInstanceAlertTrigger $filter) {
            $className = $filter->getActualClassNameForMorph($filter->trigger_type);
            $details = $className::create();
            $filter->details()->associate($details);
            $filter->save();
        });
        // Delete the row for the actual filter when deleting the polymorphic relationship row in UACReportModuleInstanceSavedFilter
        static::deleted(function (UACReportModuleInstanceAlertTrigger $filter) {
            $details = $filter->details;
            $details->delete();
        });
    }

    public function uacReportModuleInstanceAlert()
    {
        return $this->belongsTo(UACReportModuleInstanceAlert::class, 'uacreportmoduleinstancealert_id', 'id');
    }

    /**
     * Get the relationship to the actual class type for the trigger
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function details() {
        return $this->belongsTo($this->getActualClassNameForMorph($this->trigger_type), 'trigger_id', 'id');
    }

    public function getIsTriggeredAttribute() {
        return $this->details->is_triggered;
    }

    public function getReadableDescriptionAttribute() {
        return $this->details->readable_description;
    }
}
