<?php

namespace Marcolin\Models;

use DB;


class SalesRep extends WebModel
{
    protected $table = "SalesReps";


    public function regionalRep() {
        return $this->belongsTo(SalesRep::class, 'regionalManager', 'salesGroup');
    }

    public function districtRep() {
        return $this->belongsTo(SalesRep::class, 'districtManager', 'salesGroup');
    }

    public function brands()
    {
        return $this->belongsToMany(Brand::class, 'SalesRep_Customer_Brand', 'salesrep_id', 'brand_id')
            ->wherePivot('deleted_at', '=', '0000-00-00 00:00:00')
            ->distinct();
    }

    public function brandNames(){
        return $this->brands->pluck('brandName')->all();
    }

    public function salesDistrict()
    {
        return $this->belongsToMany(SalesDistrict::class, 'SalesRep_Customer_Brand', 'salesrep_id', 'salesDistrict_id')
            ->wherePivot('deleted_at', '=', '0000-00-00 00:00:00')
            ->withPivot('brand_id');
    }

    public function salesDistrictTrashed()
    {
        return $this->belongsToMany(SalesDistrict::class, 'SalesRep_Customer_Brand', 'salesrep_id', 'salesDistrict_id')
            ->wherePivot('deleted_at', '=', '0000-00-00 00:00:00')
            ->withPivot('brand_id')
            ->withTrashed();
    }

    public function salesTargets() {
        return $this->hasMany(SalesTarget::class, 'salesrep_id');
    }

    public function getRepName() {
        if ($this->salesGroupName != null && $this->salesGroupName != '') {
            return $this->salesGroupName;
        } else {
            return $this->salesGroupDescription;
        }
    }

    public function getRepCode() {
        return $this->salesGroup;
    }

    public function getRepNumberAttribute() {
        return $this->getRepCode();
    }

    public function getNameAttribute() {
        return $this->getRepName();
    }
}
