<?php
/**
 * Created by PhpStorm.
 * User: ntaylor
 * Date: 10/16/18
 * Time: 8:12 AM
 */

namespace Marcolin\Models;


class PromotionCurrentOrderQuantityTrigger_Product extends WebModel {
    protected $table = 'PromotionCurrentOrderQuantityTrigger_Product';
    protected $fillable = ['excluded', 'commit_sequence'];

    public function itemQuantityTrigger() {
        return $this->belongsTo(PromotionCurrentOrderQuantityTrigger::class,
            'PromotionCurrentOrderQuantityTrigger_id', 'id');
    }

    public function scopeTriggerProduct($query, $trigger_id, $product_id, $product_type) {
        return $query->where(
            [
                'PromotionCurrentOrderQuantityTrigger_id' => $trigger_id,
                'product_id' => $product_id,
                'product_type' => $product_type
            ]
        );
    }

    use HasCommitSequence;
}