<?php

namespace Marcolin\Models;

use Illuminate\Database\Eloquent\Builder;

/**
 * Class Promotion
 * @package Hilco\Models
 *
 * @method static Builder active()
 */
class PromotionCurrentOrderQuantityTrigger extends PromotionTriggerDetails
{
    protected $table = 'PromotionCurrentOrderQuantityTriggers';
    protected $fillable = ['minimum_quantity', 'any_product', 'almost_qualified'];

    public function webBrands() {
        return $this
            ->morphedByMany(WebBrand::class, 'product', 'PromotionCurrentOrderQuantityTrigger_Product', 'PromotionCurrentOrderQuantityTrigger_id')
            ->withPivot(['excluded'])
            ->where('PromotionCurrentOrderQuantityTrigger_Product.deleted_at', '0000-00-00 00:00:00');
    }

    public function styles()
    {
        return $this
            ->morphedByMany(Style::class, 'product', 'PromotionCurrentOrderQuantityTrigger_Product', 'PromotionCurrentOrderQuantityTrigger_id')
            ->withPivot(['excluded']);
    }

    public function getRelationForProductTableType($tableType) {
        //
        if ($tableType === 'webFamily' || $tableType === 'webCategory') {
            $relationName = substr($tableType, 0, -1);
            $relationName .= 'ies';
        } else {
            $relationName = $tableType . 's';
        }
        return $this->$relationName();
    }

    public function isTriggered(Customer $soldToCustomer, $webCartItems) {
        $totalPartQuantity = $this->getCurrentQualifyingCartTotal($soldToCustomer, $webCartItems);

        return $totalPartQuantity >= $this->minimum_quantity;
    }

    public function hasAlmostQualifyingField() {
        return true;
    }

    public function isAlmostQualifying(Customer $soldToCustomer, $webCartItems) {
        $almostQualifyingCount = $this->getCurrentQualifyingCartTotal($soldToCustomer, $webCartItems);
        return ($almostQualifyingCount >= $this->almost_qualified) ?
            $this->minimum_quantity - $almostQualifyingCount : -1;
    }

    public function getCurrentQualifyingCartTotal(Customer $soldToCustomer, $webCartItems) {
        $totalPartQuantity = 0;

        if (!$this->any_product) {
            $relevantBrands = $this->webBrands;

            foreach ($webCartItems as $webCartItem) {
                $unit = $webCartItem->unit;
                $webBrand = $unit->webStyle->webBrand;

                if (count($relevantBrands) > 0 && $relevantBrands->contains($webBrand)) {
                    $totalPartQuantity = $totalPartQuantity + $webCartItem->quantity;
                }
            }
        } else {
            foreach ($webCartItems as $webCartItem) {
                $totalPartQuantity = $totalPartQuantity + $webCartItem->quantity;
            }
        }

        return $totalPartQuantity;
    }
}
